@echo off
setlocal

echo.
echo Setting up the ACS Sample
echo.

echo Configuring ACS
echo.

SET toolpath=C:\Program Files (x86)\Microsoft .NET Services SDK (Nov 2009 CTP)\Tools\

SET /P acsolution=Please enter your Service Namespace: 
SET /P acmgmtkey=Please enter your Management key: 
echo.

"%toolpath%acm.exe" create tokenpolicy -name:acsexample -autogeneratekey -service:%acsolution% -mgmtkey:%acmgmtkey% -simpleout > tokenpolicy.tmp
SET /p tokenpolicyid=<tokenpolicy.tmp

SET policyCreated=%tokenpolicyid:~0,3%
if "%policyCreated%"=="tp_" ( 
	    echo Token policy created 
	) else ( 
	    goto :error
	)

echo.
"%toolpath%acm.exe" create scope -name:acsexample -appliesto:http://localhost/acsexample/ -tokenpolicyid:%tokenpolicyid% -service:%acsolution% -mgmtkey:%acmgmtkey% -simpleout > scope.tmp
SET /p scopeid=<scope.tmp

SET scopeCreated=%scopeid:~0,4%
if "%scopeCreated%"=="scp_" ( 
	    echo Scope created 
	) else ( 
	    goto :error
	)

echo.
"%toolpath%acm.exe" create issuer -name:acsexample -issuername:acsexample -autogeneratekey -service:%acsolution% -mgmtkey:%acmgmtkey% -simpleout > issuer.tmp
SET /p issuerid=<issuer.tmp

SET issuerCreated=%issuerid:~0,4%
if "%issuerCreated%"=="iss_" ( 
	    echo Issuer created 
	) else ( 
	    goto :error
	)

echo.
"%toolpath%acm.exe" create rule -name:acsexamplegetmachinename -scopeid:%scopeid% -inclaimissuerid:%issuerid% -inclaimtype:group -inclaimvalue:user -outclaimtype:action -outclaimvalue:getmachinename -service:%acsolution% -mgmtkey:%acmgmtkey% -simpleout > rule.tmp
SET /p ruleid=<rule.tmp
echo getmachinename rule created (group=user)
echo.

"%toolpath%acm.exe" create rule -name:acsexamplegetuserdomainname -scopeid:%scopeid% -inclaimissuerid:%issuerid% -inclaimtype:group -inclaimvalue:user -outclaimtype:action -outclaimvalue:getuserdomainname -service:%acsolution% -mgmtkey:%acmgmtkey% -simpleout > rule.tmp
SET /p ruleid=<rule.tmp
echo getuserdomainname rule created (group=user)
echo.

"%toolpath%acm.exe" create rule -name:acsexamplegetosversion -scopeid:%scopeid% -inclaimissuerid:%issuerid% -inclaimtype:group -inclaimvalue:user -outclaimtype:action -outclaimvalue:getosversion -service:%acsolution% -mgmtkey:%acmgmtkey% -simpleout > rule.tmp
SET /p ruleid=<rule.tmp
echo getosversion rule created (group=user)
echo.

"%toolpath%acm.exe" create rule -name:acsexampleencodestring -scopeid:%scopeid% -inclaimissuerid:%issuerid% -inclaimtype:group -inclaimvalue:admin -outclaimtype:action -outclaimvalue:encodestring -service:%acsolution% -mgmtkey:%acmgmtkey% -simpleout > rule.tmp
SET /p ruleid=<rule.tmp
echo encodestring rule created (group=admin)
echo.


"%toolpath%acm.exe" get issuer -id:%issuerid% -service:%acsolution% -mgmtkey:%acmgmtkey% > key.tmp
findstr /C:=<key.tmp > keyvalue.tmp
SET /P keyvalue=<keyvalue.tmp
echo Client issuer %keyvalue%
echo Client issuer name: acsexample

"%toolpath%acm.exe" get tokenpolicy -id:%tokenpolicyid% -service:%acsolution% -mgmtkey:%acmgmtkey% > tp.tmp
findstr /C:=<tp.tmp > tpkey.tmp
SET /P tpkey=<tpkey.tmp
echo Service Token Policy %tpkey%

echo.
echo Done.

erase *.tmp

goto endscript

:error

echo.
echo Sample setup failed
goto :endscript

:endscript